<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Vieclamnganhduoc.com - Website tuyển dụng việc làm ngành dược lương cao năm 2024",
  "alternateName": "vieclamnganhduoc",
  "url": "https://vieclamnganhduoc.com/",
  "logo": "https://vieclamnganhduoc.com/wp-content/uploads/elementor/thumbs/viec-lam-nganh-duoc-white-qhpzvunmgdspabszs2xhay8f0kl66le4c25p57flww.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0827498153",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://www.youtube.com/@vieclamnganhduoc/about",
    "https://www.pinterest.com/vieclamnganhduoc/",
    "https://www.linkedin.com/in/vieclamnganhduoc/",
    "https://www.reddit.com/user/vieclamnganhduoc/",
    "https://vieclamnganhduoc.tumblr.com/",
    "https://sites.google.com/view/vieclamnganhduoc",
    "https://www.blogger.com/profile/03966898965191458246",
    "https://vieclamnganhduoccom.blogspot.com/2024/03/vieclamnganhduoccom-website-tuyen-dung.html"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Vieclamnganhduoc.com - Website tuyển dụng việc làm ngành dược lương cao năm 2024",
  "image": "https://vieclamnganhduoc.com/wp-content/uploads/elementor/thumbs/viec-lam-nganh-duoc-white-qhpzvunmgdspabszs2xhay8f0kl66le4c25p57flww.png",
  "@id": "https://vieclamnganhduoc.com/",
  "url": "https://vieclamnganhduoc.com/",
  "telephone": "0827498153",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "196 Liên Tỉnh 5, Phường 6, Quận 8, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.736901,
    "longitude": 106.656059
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://www.youtube.com/@vieclamnganhduoc/about",
    "https://www.pinterest.com/vieclamnganhduoc/",
    "https://www.linkedin.com/in/vieclamnganhduoc/",
    "https://www.reddit.com/user/vieclamnganhduoc/",
    "https://vieclamnganhduoc.tumblr.com/",
    "https://sites.google.com/view/vieclamnganhduoc",
    "https://www.blogger.com/profile/03966898965191458246",
    "https://vieclamnganhduoccom.blogspot.com/2024/03/vieclamnganhduoccom-website-tuyen-dung.html"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Lê Thùy Chi",
  "url": "https://vieclamnganhduoc.com/author/admin/",
  "image": "https://htmediagroup.vn/wp-content/uploads/2022/09/Nhan-vien-Luat-5-min.jpg",
  "sameAs": [
    "https://www.youtube.com/@ceolethuychi",
    "https://www.pinterest.com/ceolethuychi/",
    "https://www.linkedin.com/in/lethuychi/",
    "https://twitter.com/ceolethuychi",
    "https://www.reddit.com/user/lethuychi/",
    "https://ceolethuychi.tumblr.com/",
    "https://sites.google.com/view/lethuychi/",
    "https://www.blogger.com/profile/09069079692663336383"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "vieclamnganhduoc"
  }  
}
</script>
	
	<meta name='dmca-site-verification' content='OG1NT1Q5M1owQTdxQk1ScmxBZ0o0cTJ0eTlzcGg1STlhT2lkT1lWaW1icz01' />
	<meta name="google-site-verification" content="CGuP9R6iV0RBvUf9UosCWSsN9oDSYllxcjnpmBtwvAk" />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">	
	<?php wp_head(); ?>
	<!-- Google tag (gtag.js) -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=G-4Z0FQMWQSC"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());
	  gtag('config', 'G-4Z0FQMWQSC');
	</script>
	<meta name='dmca-site-verification' content='OG1NT1Q5M1owQTdxQk1ScmxBZ0o0cTJ0eTlzcGg1STlhT2lkT1lWaW1icz01' />
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">